package fr.asip.cps3.exemple.vues.menus;

import fr.asip.cps3.exemple.modele.objets.Token;

/**
 * Classe modlisant un menu de type Token
 *
 */
public class MenuToken extends Menu {
	
	private static final long serialVersionUID = -4943717740253930421L;
	
	/**
	 * Token associ  l'item de menu
	 */
	private Token token;

	/**
	 * Constructeur  5 arguments
	 * @param token Token associ au menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 */
	public MenuToken(Token token, String idParent, boolean enable, boolean visible) {
		super(idParent+",", idParent, "", enable, visible);
		this.token = token;
		if(token != null) {
			setId(getIdParent()+","+token.getIdSlotToken());
			setText(token.getLibelle());
		}
	}

	/**
	 * Accesseur
	 * @return Token associ  l'item de menu
	 */
	public Token getToken() {
		return token;
	}
}
